// MyVideoWnd.cpp : implementation file
//

#include "stdafx.h"
#include "ScfPlayerDlg.h"
#include "MyVideoWnd.h"
#include "MyViewManager.h"
#include "MyLayout.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

typedef struct tagDSVIDEOWND
{
	MyVideoWnd* pwndSrc;
}DSVIDEOWND, *PDSVIDEOWND;

#define FMT_VIDEOWND "DSVIDEOWND"

extern VOID SC_DEBUG( CHAR * pszStr, ... );

/////////////////////////////////////////////////////////////////////////////
IMPLEMENT_DYNAMIC(MyVideoWnd, CWnd)

MyVideoWnd::MyVideoWnd() : m_pDropTarget( NULL ) , m_pViewManager( NULL ) , m_nWndID( -1 ), m_bConnectVideo( FALSE )
{
	m_nSubChannelNumber		=	0;

	m_pParentDlg						= NULL;

	m_strShowText					= "NO SIGNAL";

	m_pDropTarget					= new WndDropTarget<MyVideoWnd>;	
}

MyVideoWnd::~MyVideoWnd()
{
	if (m_pDropTarget) { delete m_pDropTarget; m_pDropTarget = NULL; }
}

BEGIN_MESSAGE_MAP(MyVideoWnd, CWnd)
	//{{AFX_MSG_MAP(MyVideoWnd)
	ON_WM_TIMER()
	ON_WM_PAINT()
	ON_WM_CLOSE()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_WM_DESTROY()
	ON_WM_CHAR()
	ON_WM_ERASEBKGND()
	ON_WM_WINDOWPOSCHANGED()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// MyVideoWnd message handlers

BOOL MyVideoWnd::PreCreateWindow(CREATESTRUCT& cs) 
{	
	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;

	cs.style     |=  WS_BORDER;

	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS, ::LoadCursor(NULL, IDC_ARROW), HBRUSH(CTLCOLOR_BTN), NULL);

	return CWnd::PreCreateWindow(cs);
}
 
void MyVideoWnd::OnWindowPosChanged( WINDOWPOS* lpwndpos )
{
	CWnd::OnWindowPosChanged( lpwndpos );
}

void MyVideoWnd::OnClose() 
{	
	CWnd::OnClose();
}

void MyVideoWnd::OnMouseMove(UINT nFlags, CPoint point) 
{
	ClientToScreen(&point);

	::SendMessage(::GetParent(m_hWnd), WM_MOUSEMOVE, 0, MAKELPARAM(point.x,point.y));	

	SetFocus();
}

void MyVideoWnd::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
   //if (m_pViewManager != NULL) { m_pViewManager->Notify(this , 0); }

	//GetParent()->SendMessage( WM_LBUTTONDBLCLK, 0, 0 );

	CWnd::OnLButtonDblClk(nFlags, point);
}

void MyVideoWnd::OnRButtonDown(UINT nFlags, CPoint point) 
{	
	CWnd::OnRButtonDown(nFlags, point);

	POINT point2;

	GetCursorPos( &point2 );
	
	if ( m_pParentDlg != NULL )
	{
		::SendMessage( m_pParentDlg->GetSafeHwnd(), WM_RBUTTONDOWN, 0, 0 );
	}
}

void MyVideoWnd::OnLButtonDown(UINT nFlags, CPoint point) 
{		
	HANDLE hData = ::GlobalAlloc (GMEM_MOVEABLE | GMEM_SHARE, sizeof (DSVIDEOWND));

	DSVIDEOWND* pDS = (DSVIDEOWND*) GlobalLock(hData);	

	pDS->pwndSrc = this;

	GlobalUnlock(hData);			// done modifying memory

    UINT nFormat = CLIPBOARD_FORMAT(FMT_VIDEOWND);

 	m_DataSource.CacheGlobalData(nFormat, hData);

	// perform the drag and drop operation
	DROPEFFECT dropEffect;

	dropEffect = m_DataSource.DoDragDrop(DROPEFFECT_COPY | DROPEFFECT_MOVE);

	//SC_DEBUG("Drop Effect : %ld", dropEffect);

	// remove the selection if this was a move operation
	if (dropEffect == DROPEFFECT_MOVE)
	{
	}

	// The OLE library eats the button up message, make the list box
	// happy by simulating another button up message.
	// PostMessage(WM_LBUTTONUP, nFlags, MAKELONG(point.x, point.y));
}

DROPEFFECT MyVideoWnd::OnDragEnter(COleDataObject *pDataObject, DWORD dwKeyState, CPoint point)
{
	return OnDragOver(pDataObject, dwKeyState, point);
}

DROPEFFECT MyVideoWnd::OnDragOver(COleDataObject *pDataObject, DWORD dwKeyState, CPoint point)
{
	DROPEFFECT	dropEffect = DROPEFFECT_NONE;

	if (pDataObject->IsDataAvailable(CLIPBOARD_FORMAT(FMT_VIDEOWND)))
	{
		dropEffect = (dwKeyState & MK_CONTROL) ? DROPEFFECT_COPY : DROPEFFECT_MOVE;
	}

	OnDrop(pDataObject, dropEffect, point);

	return dropEffect;
}

void MyVideoWnd::OnDragLeave()
{
}

BOOL MyVideoWnd::OnDrop(COleDataObject *pDataObject, DROPEFFECT dropEffect, CPoint point)
{
	HGLOBAL	hGlobal = pDataObject->GetGlobalData(CLIPBOARD_FORMAT(FMT_VIDEOWND));
	
	if (hGlobal == NULL)  { return FALSE; }

	DSVIDEOWND WndData = *((DSVIDEOWND*) GlobalLock(hGlobal));

	GlobalUnlock(hGlobal);
	GlobalFree(hGlobal);

	if (m_pViewManager == NULL) { return FALSE; }

	if (WndData.pwndSrc == this) { return FALSE; }

	m_pViewManager->SwapView(WndData.pwndSrc, this);

	return TRUE;
}

int MyVideoWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;	

	//BOOL bRegister = m_pDropTarget->Register(this);

	return 0;
}

void MyVideoWnd::SetViewManager(MyViewManager *pMgr)
{
    m_pViewManager = pMgr;
}

void MyVideoWnd::OnSize(UINT nType, int cx, int cy) 
{		
	//SC_DEBUG( " MyVideoWnd::OnSize : m_nWndID : %d", m_nWndID  );

	CWnd::OnSize(nType, cx, cy);	
}

void MyVideoWnd::OnDestroy() 
{
	CWnd::OnDestroy();
}

void MyVideoWnd::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	(GetParent())->SendMessage(WM_CHAR, nChar, nFlags);

	CWnd::OnChar(nChar, nRepCnt, nFlags);
}

BOOL MyVideoWnd::OnEraseBkgnd(CDC* pDC) 
{
	if ( m_bConnectVideo == FALSE )
	{
		CDC *pDC = GetDC();

		HDC hDC = pDC->GetSafeHdc();

		CBrush  brush(RGB( 31, 43, 186 ));

		CRect rt;	GetClientRect(&rt);

		HBITMAP hBackBitmap = CreateCompatibleBitmap(hDC, rt.right - rt.left, rt.bottom - rt.top);		

		HDC hBitmapDC = ::CreateCompatibleDC(hDC);

		HBITMAP hOldBitmap = (HBITMAP)SelectObject(hBitmapDC, hBackBitmap);

		::FillRect(hBitmapDC, &rt, brush);	
			
		DrawText(hBitmapDC, rt.Width() / 2, rt.Height() / 2, m_strShowText, RGB(255, 0, 0));

		BitBlt(hDC, rt.left, rt.top, rt.Width(), rt.Height(), hBitmapDC, 0, 0, SRCCOPY);

		SelectObject(hBitmapDC, hOldBitmap);

		DeleteDC(hBitmapDC);

		DeleteObject(hBackBitmap);

		ReleaseDC(pDC);	
	}	

	return TRUE;

	return CWnd::OnEraseBkgnd(pDC);
}

void MyVideoWnd::DrawText(HDC hDC, int nX, int nY, CString strText, COLORREF clrColor)
{
	CDC *pDC = CDC::FromHandle( hDC );

	CPen penBlack;

	penBlack.CreatePen(PS_SOLID, 1, clrColor);

	CPen* pOldPen = pDC->SelectObject(&penBlack);

	pDC->SetTextColor(clrColor);

	pDC->SetBkColor(RGB(31, 43, 186));

	CSize txtSize;

	txtSize = pDC->GetTextExtent( strText );

	txtSize.cx = txtSize.cx / 2;
	txtSize.cy = txtSize.cy / 2;

	pDC->TextOut(nX - txtSize.cx, nY - txtSize.cy, strText);

	pDC->SelectObject(pOldPen);

	ReleaseDC(pDC);
}

void MyVideoWnd::OnPaint() 
{
	CPaintDC dc(this);	
}

LRESULT MyVideoWnd::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	return CWnd::WindowProc(message, wParam, lParam);
}

BOOL MyVideoWnd::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	
	return CWnd::PreTranslateMessage(pMsg);
}

